/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import com.hp.hpl.jena.sdb.shared.SDBNotImplemented;
import com.hp.hpl.jena.sdb.store.StoreLoader;
import com.hp.hpl.jena.sdb.store.TupleLoader;

public class TupleGraphLoader
implements StoreLoader {
    private TupleLoader loader;

    public TupleGraphLoader(TupleLoader loader) {
        if (loader.getTableDesc() == null) {
            throw new SDBInternalError("No table description for loader");
        }
        if (loader.getTableDesc().getWidth() != 3) {
            String x = String.format("Table description width is %d, not 3", loader.getTableDesc().getWidth());
            throw new SDBInternalError(x);
        }
        this.loader = loader;
    }

    @Override
    public void addTriple(Triple triple) {
        this.loader.load(TupleGraphLoader.row(triple));
    }

    @Override
    public void deleteTriple(Triple triple) {
        this.loader.unload(TupleGraphLoader.row(triple));
    }

    private static Node[] row(Triple triple) {
        Node[] nodes = new Node[]{triple.getSubject(), triple.getPredicate(), triple.getObject()};
        return nodes;
    }

    @Override
    public void close() {
        this.loader.finish();
    }

    @Override
    public void startBulkUpdate() {
        this.loader.start();
    }

    @Override
    public void finishBulkUpdate() {
        this.loader.finish();
    }

    @Override
    public int getChunkSize() {
        throw new SDBNotImplemented("TupleGraphLoader.getChunkSize");
    }

    @Override
    public void setChunkSize(int chunks) {
        throw new SDBNotImplemented("TupleGraphLoader.setChunkSize");
    }

    @Override
    public boolean getUseThreading() {
        throw new SDBNotImplemented("TupleGraphLoader.getUseThreading");
    }

    @Override
    public void setUseThreading(boolean useThreading) {
        throw new SDBNotImplemented("TupleGraphLoader.setUseThreading");
    }

    @Override
    public void deleteAll() {
        throw new SDBNotImplemented("TupleGraphLoader.deleteAll");
    }
}

