/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.util;

import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import java.sql.SQLException;

public class H2Utils {
    public static void shutdown(Store store) {
        H2Utils.shutdown(store.getConnection());
    }

    public static void shutdown(SDBConnection sdb) {
        try {
            if (sdb.hasSQLConnection()) {
                sdb.exec("SHUTDOWN COMPACT;");
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }

    public static void checkpoint(Store store) {
        H2Utils.checkpoint(store.getConnection());
    }

    public static void checkpoint(SDBConnection sdb) {
        try {
            if (sdb.hasSQLConnection()) {
                sdb.exec("CHECKPOINT DEFRAG;");
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }
}

