/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function;

import java.math.BigInteger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class IntegerCast
implements Function {
    public String getURI() {
        return XMLSchema.INTEGER.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("xsd:integer cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            URI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                String integerValue = XMLDatatypeUtil.collapseWhiteSpace((String)literal.getLabel());
                if (XMLDatatypeUtil.isValidInteger((String)integerValue)) {
                    return valueFactory.createLiteral(integerValue, XMLSchema.INTEGER);
                }
            } else if (datatype != null) {
                if (datatype.equals((Object)XMLSchema.INTEGER)) {
                    return literal;
                }
                if (XMLDatatypeUtil.isNumericDatatype((URI)datatype)) {
                    try {
                        BigInteger integerValue = literal.integerValue();
                        return valueFactory.createLiteral(integerValue.toString(), XMLSchema.INTEGER);
                    }
                    catch (NumberFormatException e) {
                        throw new ValueExprEvaluationException(e.getMessage(), e);
                    }
                }
                if (datatype.equals((Object)XMLSchema.BOOLEAN)) {
                    try {
                        return valueFactory.createLiteral(literal.booleanValue() ? "1" : "0", XMLSchema.INTEGER);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ValueExprEvaluationException(e.getMessage(), e);
                    }
                }
            }
        }
        throw new ValueExprEvaluationException("Invalid argument for xsd:integer cast: " + args[0]);
    }
}

