/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class UpperCase
implements Function {
    public String getURI() {
        return FN.UPPER_CASE.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("UCASE requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                String lexicalValue = literal.getLabel().toUpperCase();
                String language = literal.getLanguage();
                if (language != null) {
                    return valueFactory.createLiteral(lexicalValue, language);
                }
                if (XMLSchema.STRING.equals((Object)literal.getDatatype())) {
                    return valueFactory.createLiteral(lexicalValue, XMLSchema.STRING);
                }
                return valueFactory.createLiteral(lexicalValue);
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

