/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class OrderLimitOptimizer
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new OrderOptimizer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OrderOptimizer
    extends QueryModelVisitorBase<RuntimeException> {
        private boolean variablesProjected = true;
        private Projection projection;

        protected OrderOptimizer() {
        }

        public void meet(Projection node) {
            this.projection = node;
            node.getArg().visit((QueryModelVisitor)this);
            this.projection = null;
        }

        public void meet(Order node) {
            QueryModelNode parent;
            for (OrderElem e : node.getElements()) {
                e.visit((QueryModelVisitor)this);
            }
            if (this.variablesProjected && this.projection == (parent = node.getParentNode())) {
                node.replaceWith((QueryModelNode)node.getArg().clone());
                node.setArg((TupleExpr)this.projection.clone());
                Order replacement = node.clone();
                this.projection.replaceWith((QueryModelNode)replacement);
                QueryModelNode distinct = replacement.getParentNode();
                if (distinct instanceof Distinct) {
                    distinct.replaceWith((QueryModelNode)new Reduced((TupleExpr)replacement.clone()));
                }
            }
        }

        public void meet(Var node) {
            if (this.projection != null) {
                boolean projected = false;
                for (ProjectionElem e : this.projection.getProjectionElemList().getElements()) {
                    String source = e.getSourceName();
                    String target = e.getTargetName();
                    if (!node.getName().equals(source) || !node.getName().equals(target)) continue;
                    projected = true;
                    break;
                }
                if (!projected) {
                    this.variablesProjected = false;
                }
            }
        }
    }
}

