/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.LookAheadIteration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.impl.EmptyBindingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BottomUpJoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private volatile CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private List<BindingSet> scanList;
    private CloseableIteration<BindingSet, QueryEvaluationException> restIter;
    private HashMap<BindingSet, ArrayList<BindingSet>> hashTable;
    private Set<String> joinAttributes;
    private BindingSet currentScanElem;
    private ArrayList<BindingSet> hashTableValues;

    public BottomUpJoinIterator(EvaluationStrategy strategy, Join join, BindingSet bindings) throws QueryEvaluationException {
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = strategy.evaluate(join.getRightArg(), bindings);
        this.joinAttributes = join.getLeftArg().getBindingNames();
        this.joinAttributes.retainAll(join.getRightArg().getBindingNames());
        this.hashTable = null;
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.hashTable == null) {
            this.setupHashTable();
        }
        while (this.currentScanElem == null) {
            if (this.scanList.size() > 0) {
                this.currentScanElem = this.scanList.remove(0);
            } else if (this.restIter.hasNext()) {
                this.currentScanElem = (BindingSet)this.restIter.next();
            } else {
                return null;
            }
            if (this.currentScanElem instanceof EmptyBindingSet) {
                this.hashTableValues = new ArrayList();
                for (BindingSet key : this.hashTable.keySet()) {
                    this.hashTableValues.addAll((Collection<BindingSet>)this.hashTable.get(key));
                }
                continue;
            }
            BindingSet key = this.calcKey(this.currentScanElem, this.joinAttributes);
            if (this.hashTable.containsKey(key)) {
                this.hashTableValues = new ArrayList(this.hashTable.get(key));
                continue;
            }
            this.currentScanElem = null;
            this.hashTableValues = null;
        }
        BindingSet nextHashTableValue = this.hashTableValues.remove(0);
        QueryBindingSet result = new QueryBindingSet(this.currentScanElem);
        for (String name : nextHashTableValue.getBindingNames()) {
            Binding b = nextHashTableValue.getBinding(name);
            if (result.hasBinding(name)) continue;
            result.addBinding(b);
        }
        if (this.hashTableValues.size() == 0) {
            this.currentScanElem = null;
            this.hashTableValues = null;
        }
        return result;
    }

    protected void handleClose() throws QueryEvaluationException {
        super.handleClose();
        this.leftIter.close();
        this.rightIter.close();
        this.hashTable = null;
        this.hashTableValues = null;
        this.scanList = null;
    }

    private BindingSet calcKey(BindingSet bindings, Set<String> commonVars) {
        QueryBindingSet q = new QueryBindingSet();
        for (String varName : commonVars) {
            Binding b = bindings.getBinding(varName);
            if (b == null) continue;
            q.addBinding(b);
        }
        return q;
    }

    private void setupHashTable() throws QueryEvaluationException {
        this.hashTable = new HashMap();
        ArrayList<BindingSet> leftArgResults = new ArrayList<BindingSet>();
        ArrayList<BindingSet> rightArgResults = new ArrayList<BindingSet>();
        while (this.leftIter.hasNext() && this.rightIter.hasNext()) {
            BindingSet b = (BindingSet)this.leftIter.next();
            leftArgResults.add(b);
            b = (BindingSet)this.rightIter.next();
            rightArgResults.add(b);
        }
        ArrayList<BindingSet> smallestResult = null;
        if (this.leftIter.hasNext()) {
            smallestResult = rightArgResults;
            this.scanList = leftArgResults;
            this.restIter = this.leftIter;
        } else {
            smallestResult = leftArgResults;
            this.scanList = rightArgResults;
            this.restIter = this.rightIter;
        }
        for (BindingSet b : smallestResult) {
            BindingSet hashKey = this.calcKey(b, this.joinAttributes);
            ArrayList<BindingSet> hashValue = null;
            hashValue = this.hashTable.containsKey(hashKey) ? this.hashTable.get(hashKey) : new ArrayList<BindingSet>();
            hashValue.add(b);
            this.hashTable.put(hashKey, hashValue);
        }
    }
}

