/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.LookAheadIteration;
import java.util.NoSuchElementException;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final EvaluationStrategy strategy;
    private final Join join;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private volatile CloseableIteration<BindingSet, QueryEvaluationException> rightIter;

    public JoinIterator(EvaluationStrategy strategy, Join join, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join;
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = new EmptyIteration();
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            while (this.rightIter.hasNext() || this.leftIter.hasNext()) {
                if (this.rightIter.hasNext()) {
                    return (BindingSet)this.rightIter.next();
                }
                this.rightIter.close();
                if (!this.leftIter.hasNext()) continue;
                this.rightIter = this.strategy.evaluate(this.join.getRightArg(), (BindingSet)this.leftIter.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    protected void handleClose() throws QueryEvaluationException {
        super.handleClose();
        this.leftIter.close();
        this.rightIter.close();
    }
}

