/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionIterator
extends ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException> {
    private final Projection projection;
    private final BindingSet parentBindings;

    public ProjectionIterator(Projection projection, CloseableIteration<BindingSet, QueryEvaluationException> iter, BindingSet parentBindings) throws QueryEvaluationException {
        super(iter);
        this.projection = projection;
        this.parentBindings = parentBindings;
    }

    protected BindingSet convert(BindingSet sourceBindings) throws QueryEvaluationException {
        return ProjectionIterator.project(this.projection.getProjectionElemList(), sourceBindings, this.parentBindings);
    }

    public static BindingSet project(ProjectionElemList projElemList, BindingSet sourceBindings, BindingSet parentBindings) {
        QueryBindingSet resultBindings = new QueryBindingSet(parentBindings);
        for (ProjectionElem pe : projElemList.getElements()) {
            Value targetValue = sourceBindings.getValue(pe.getSourceName());
            if (targetValue == null) continue;
            resultBindings.setBinding(pe.getTargetName(), targetValue);
        }
        return resultBindings;
    }
}

