/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.inferencer.fc;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import info.aduna.text.ASCIIUtil;
import java.util.Collection;
import java.util.Iterator;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.openrdf.sail.inferencer.InferencerConnectionWrapper;
import org.openrdf.sail.inferencer.fc.RDFSRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForwardChainingRDFSInferencerConnection
extends InferencerConnectionWrapper
implements SailConnectionListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean statementsRemoved;
    private Graph newStatements;
    private Graph newThisIteration;
    private boolean[] checkRule = new boolean[21];
    private boolean[] checkRuleNextIter = new boolean[21];
    private int totalInferred = 0;
    private int[] ruleCount = new int[21];

    public ForwardChainingRDFSInferencerConnection(InferencerConnection con) {
        super(con);
        con.addConnectionListener(this);
    }

    public void statementAdded(Statement st) {
        if (this.statementsRemoved) {
            return;
        }
        if (this.newStatements == null) {
            this.newStatements = new GraphImpl();
        }
        this.newStatements.add((Object)st);
    }

    public void statementRemoved(Statement st) {
        this.statementsRemoved = true;
        this.newStatements = null;
    }

    public void flushUpdates() throws SailException {
        super.flushUpdates();
        if (this.statementsRemoved) {
            this.logger.debug("statements removed, starting inferencing from scratch");
            this.clearInferred(new Resource[0]);
            this.addAxiomStatements();
            this.newStatements = new GraphImpl();
            Iterations.addAll((Iteration)this.getWrappedConnection().getStatements(null, null, null, true, new Resource[0]), (Collection)this.newStatements);
            this.statementsRemoved = false;
        }
        this.doInferencing();
    }

    public void rollback() throws SailException {
        super.rollback();
        this.statementsRemoved = false;
        this.newStatements = null;
    }

    protected void addAxiomStatements() throws SailException {
        this.logger.debug("Inserting axiom statements");
        this.addInferredStatement((Resource)RDF.TYPE, RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDF.SUBJECT, RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDF.PREDICATE, RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDF.OBJECT, RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDF.FIRST, RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDF.REST, RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDF.VALUE, RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
        this.addInferredStatement((Resource)RDF.TYPE, RDFS.DOMAIN, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.DOMAIN, RDFS.DOMAIN, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.RANGE, RDFS.DOMAIN, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.SUBPROPERTYOF, RDFS.DOMAIN, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.SUBCLASSOF, RDFS.DOMAIN, (Value)RDFS.CLASS, new Resource[0]);
        this.addInferredStatement((Resource)RDF.SUBJECT, RDFS.DOMAIN, (Value)RDF.STATEMENT, new Resource[0]);
        this.addInferredStatement((Resource)RDF.PREDICATE, RDFS.DOMAIN, (Value)RDF.STATEMENT, new Resource[0]);
        this.addInferredStatement((Resource)RDF.OBJECT, RDFS.DOMAIN, (Value)RDF.STATEMENT, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.MEMBER, RDFS.DOMAIN, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDF.FIRST, RDFS.DOMAIN, (Value)RDF.LIST, new Resource[0]);
        this.addInferredStatement((Resource)RDF.REST, RDFS.DOMAIN, (Value)RDF.LIST, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.SEEALSO, RDFS.DOMAIN, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.ISDEFINEDBY, RDFS.DOMAIN, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.COMMENT, RDFS.DOMAIN, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.LABEL, RDFS.DOMAIN, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDF.VALUE, RDFS.DOMAIN, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDF.TYPE, RDFS.RANGE, (Value)RDFS.CLASS, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.DOMAIN, RDFS.RANGE, (Value)RDFS.CLASS, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.RANGE, RDFS.RANGE, (Value)RDFS.CLASS, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.SUBPROPERTYOF, RDFS.RANGE, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.SUBCLASSOF, RDFS.RANGE, (Value)RDFS.CLASS, new Resource[0]);
        this.addInferredStatement((Resource)RDF.SUBJECT, RDFS.RANGE, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDF.PREDICATE, RDFS.RANGE, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDF.OBJECT, RDFS.RANGE, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.MEMBER, RDFS.RANGE, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDF.FIRST, RDFS.RANGE, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDF.REST, RDFS.RANGE, (Value)RDF.LIST, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.SEEALSO, RDFS.RANGE, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.ISDEFINEDBY, RDFS.RANGE, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.COMMENT, RDFS.RANGE, (Value)RDFS.LITERAL, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.LABEL, RDFS.RANGE, (Value)RDFS.LITERAL, new Resource[0]);
        this.addInferredStatement((Resource)RDF.VALUE, RDFS.RANGE, (Value)RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement((Resource)RDF.ALT, RDFS.SUBCLASSOF, (Value)RDFS.CONTAINER, new Resource[0]);
        this.addInferredStatement((Resource)RDF.BAG, RDFS.SUBCLASSOF, (Value)RDFS.CONTAINER, new Resource[0]);
        this.addInferredStatement((Resource)RDF.SEQ, RDFS.SUBCLASSOF, (Value)RDFS.CONTAINER, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.CONTAINERMEMBERSHIPPROPERTY, RDFS.SUBCLASSOF, (Value)RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.ISDEFINEDBY, RDFS.SUBPROPERTYOF, (Value)RDFS.SEEALSO, new Resource[0]);
        this.addInferredStatement((Resource)RDF.XMLLITERAL, RDF.TYPE, (Value)RDFS.DATATYPE, new Resource[0]);
        this.addInferredStatement((Resource)RDF.XMLLITERAL, RDFS.SUBCLASSOF, (Value)RDFS.LITERAL, new Resource[0]);
        this.addInferredStatement((Resource)RDFS.DATATYPE, RDFS.SUBCLASSOF, (Value)RDFS.CLASS, new Resource[0]);
    }

    protected void doInferencing() throws SailException {
        int i;
        if (!this.hasNewStatements()) {
            return;
        }
        this.totalInferred = 0;
        int iteration = 0;
        int nofInferred = 1;
        for (i = 0; i < 21; ++i) {
            this.ruleCount[i] = 0;
            this.checkRuleNextIter[i] = true;
        }
        while (this.hasNewStatements()) {
            this.logger.debug("starting iteration " + ++iteration);
            this.prepareIteration();
            nofInferred = 0;
            nofInferred += this.applyRule(0);
            nofInferred += this.applyRule(1);
            nofInferred += this.applyRule(2);
            nofInferred += this.applyRule(3);
            nofInferred += this.applyRule(4);
            nofInferred += this.applyRule(5);
            nofInferred += this.applyRule(6);
            nofInferred += this.applyRule(7);
            nofInferred += this.applyRule(8);
            nofInferred += this.applyRule(9);
            nofInferred += this.applyRule(10);
            nofInferred += this.applyRule(11);
            nofInferred += this.applyRule(12);
            nofInferred += this.applyRule(13);
            nofInferred += this.applyRule(14);
            nofInferred += this.applyRule(15);
            nofInferred += this.applyRule(16);
            nofInferred += this.applyRule(17);
            nofInferred += this.applyRule(18);
            nofInferred += this.applyRule(19);
            this.logger.debug("iteration " + iteration + " done; inferred " + (nofInferred += this.applyRule(20)) + " new statements");
            this.totalInferred += nofInferred;
        }
        this.logger.debug("---RdfMTInferencer statistics:---");
        this.logger.debug("total statements inferred = " + this.totalInferred);
        for (i = 0; i < 21; ++i) {
            this.logger.debug("rule " + RDFSRules.RULENAMES[i] + ":\t#inferred=" + this.ruleCount[i]);
        }
        this.logger.debug("---end of statistics:---");
    }

    protected void prepareIteration() {
        for (int i = 0; i < 21; ++i) {
            this.checkRule[i] = this.checkRuleNextIter[i];
            this.checkRuleNextIter[i] = false;
        }
        this.newThisIteration = this.newStatements;
        this.newStatements = new GraphImpl();
    }

    protected boolean hasNewStatements() {
        return this.newStatements != null && !this.newStatements.isEmpty();
    }

    protected void updateTriggers(int ruleNo, int nofInferred) {
        if (nofInferred > 0) {
            int n = ruleNo;
            this.ruleCount[n] = this.ruleCount[n] + nofInferred;
            boolean[] triggers = RDFSRules.TRIGGERS[ruleNo];
            for (int i = 0; i < 21; ++i) {
                if (!triggers[i]) continue;
                this.checkRuleNextIter[i] = true;
            }
        }
    }

    protected int applyRule(int rule) throws SailException {
        if (!this.checkRule[rule]) {
            return 0;
        }
        int nofInferred = 0;
        nofInferred = this.applyRuleInternal(rule);
        this.updateTriggers(rule, nofInferred);
        return nofInferred;
    }

    protected int applyRuleInternal(int rule) throws SailException {
        int result = 0;
        switch (rule) {
            case 0: {
                result = this.applyRuleRdf1();
                break;
            }
            case 1: {
                result = this.applyRuleRdfs2_1();
                break;
            }
            case 2: {
                result = this.applyRuleRdfs2_2();
                break;
            }
            case 3: {
                result = this.applyRuleRdfs3_1();
                break;
            }
            case 4: {
                result = this.applyRuleRdfs3_2();
                break;
            }
            case 5: {
                result = this.applyRuleRdfs4a();
                break;
            }
            case 6: {
                result = this.applyRuleRdfs4b();
                break;
            }
            case 7: {
                result = this.applyRuleRdfs5_1();
                break;
            }
            case 8: {
                result = this.applyRuleRdfs5_2();
                break;
            }
            case 9: {
                result = this.applyRuleRdfs6();
                break;
            }
            case 10: {
                result = this.applyRuleRdfs7_1();
                break;
            }
            case 11: {
                result = this.applyRuleRdfs7_2();
                break;
            }
            case 12: {
                result = this.applyRuleRdfs8();
                break;
            }
            case 13: {
                result = this.applyRuleRdfs9_1();
                break;
            }
            case 14: {
                result = this.applyRuleRdfs9_2();
                break;
            }
            case 15: {
                result = this.applyRuleRdfs10();
                break;
            }
            case 16: {
                result = this.applyRuleRdfs11_1();
                break;
            }
            case 17: {
                result = this.applyRuleRdfs11_2();
                break;
            }
            case 18: {
                result = this.applyRuleRdfs12();
                break;
            }
            case 19: {
                result = this.applyRuleRdfs13();
                break;
            }
            case 20: {
                result = this.applyRuleX1();
                break;
            }
        }
        return result;
    }

    private int applyRuleRdf1() throws SailException {
        int nofInferred = 0;
        Iterator iter = this.newThisIteration.match(null, null, null, new Resource[0]);
        while (iter.hasNext()) {
            Statement st = (Statement)iter.next();
            boolean added = this.addInferredStatement((Resource)st.getPredicate(), RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs2_1() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, null, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource xxx = nt.getSubject();
            URI aaa = nt.getPredicate();
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements((Resource)aaa, RDFS.DOMAIN, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value zzz = t1.getObject();
                if (!(zzz instanceof Resource) || !(added = this.addInferredStatement(xxx, RDF.TYPE, zzz, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs2_2() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, RDFS.DOMAIN, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource aaa = nt.getSubject();
            Value zzz = nt.getObject();
            if (!(aaa instanceof URI) || !(zzz instanceof Resource)) continue;
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements(null, (URI)aaa, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                Statement t1 = (Statement)t1Iter.next();
                Resource xxx = t1.getSubject();
                boolean added = this.addInferredStatement(xxx, RDF.TYPE, zzz, new Resource[0]);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs3_1() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, null, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            URI aaa = nt.getPredicate();
            Value uuu = nt.getObject();
            if (!(uuu instanceof Resource)) continue;
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements((Resource)aaa, RDFS.RANGE, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value zzz = t1.getObject();
                if (!(zzz instanceof Resource) || !(added = this.addInferredStatement((Resource)uuu, RDF.TYPE, zzz, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs3_2() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, RDFS.RANGE, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource aaa = nt.getSubject();
            Value zzz = nt.getObject();
            if (!(aaa instanceof URI) || !(zzz instanceof Resource)) continue;
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements(null, (URI)aaa, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value uuu = t1.getObject();
                if (!(uuu instanceof Resource) || !(added = this.addInferredStatement((Resource)uuu, RDF.TYPE, zzz, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs4a() throws SailException {
        int nofInferred = 0;
        Iterator iter = this.newThisIteration.match(null, null, null, new Resource[0]);
        while (iter.hasNext()) {
            Statement st = (Statement)iter.next();
            boolean added = this.addInferredStatement(st.getSubject(), RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs4b() throws SailException {
        int nofInferred = 0;
        Iterator iter = this.newThisIteration.match(null, null, null, new Resource[0]);
        while (iter.hasNext()) {
            boolean added;
            Statement st = (Statement)iter.next();
            Value uuu = st.getObject();
            if (!(uuu instanceof Resource) || !(added = this.addInferredStatement((Resource)uuu, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]))) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs5_1() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, RDFS.SUBPROPERTYOF, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource aaa = nt.getSubject();
            Value bbb = nt.getObject();
            if (!(bbb instanceof Resource)) continue;
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements((Resource)bbb, RDFS.SUBPROPERTYOF, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value ccc = t1.getObject();
                if (!(ccc instanceof Resource) || !(added = this.addInferredStatement(aaa, RDFS.SUBPROPERTYOF, ccc, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs5_2() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, RDFS.SUBPROPERTYOF, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource bbb = nt.getSubject();
            Value ccc = nt.getObject();
            if (!(ccc instanceof Resource)) continue;
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements(null, RDFS.SUBPROPERTYOF, (Value)bbb, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                Statement t1 = (Statement)t1Iter.next();
                Resource aaa = t1.getSubject();
                boolean added = this.addInferredStatement(aaa, RDFS.SUBPROPERTYOF, ccc, new Resource[0]);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs6() throws SailException {
        int nofInferred = 0;
        Iterator iter = this.newThisIteration.match(null, RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
        while (iter.hasNext()) {
            Statement st = (Statement)iter.next();
            Resource xxx = st.getSubject();
            boolean added = this.addInferredStatement(xxx, RDFS.SUBPROPERTYOF, (Value)xxx, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs7_1() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, null, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource xxx = nt.getSubject();
            URI aaa = nt.getPredicate();
            Value yyy = nt.getObject();
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements((Resource)aaa, RDFS.SUBPROPERTYOF, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value bbb = t1.getObject();
                if (!(bbb instanceof URI) || !(added = this.addInferredStatement(xxx, (URI)bbb, yyy, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs7_2() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, RDFS.SUBPROPERTYOF, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource aaa = nt.getSubject();
            Value bbb = nt.getObject();
            if (!(aaa instanceof URI) || !(bbb instanceof URI)) continue;
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements(null, (URI)aaa, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                Value yyy;
                Statement t1 = (Statement)t1Iter.next();
                Resource xxx = t1.getSubject();
                boolean added = this.addInferredStatement(xxx, (URI)bbb, yyy = t1.getObject(), new Resource[0]);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs8() throws SailException {
        int nofInferred = 0;
        Iterator iter = this.newThisIteration.match(null, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        while (iter.hasNext()) {
            Statement st = (Statement)iter.next();
            Resource xxx = st.getSubject();
            boolean added = this.addInferredStatement(xxx, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs9_1() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, RDFS.SUBCLASSOF, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource xxx = nt.getSubject();
            Value yyy = nt.getObject();
            if (!(yyy instanceof Resource)) continue;
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements(null, RDF.TYPE, (Value)xxx, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                Statement t1 = (Statement)t1Iter.next();
                Resource aaa = t1.getSubject();
                boolean added = this.addInferredStatement(aaa, RDF.TYPE, yyy, new Resource[0]);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs9_2() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, RDF.TYPE, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource aaa = nt.getSubject();
            Value xxx = nt.getObject();
            if (!(xxx instanceof Resource)) continue;
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements((Resource)xxx, RDFS.SUBCLASSOF, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value yyy = t1.getObject();
                if (!(yyy instanceof Resource) || !(added = this.addInferredStatement(aaa, RDF.TYPE, yyy, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs10() throws SailException {
        int nofInferred = 0;
        Iterator iter = this.newThisIteration.match(null, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        while (iter.hasNext()) {
            Statement st = (Statement)iter.next();
            Resource xxx = st.getSubject();
            boolean added = this.addInferredStatement(xxx, RDFS.SUBCLASSOF, (Value)xxx, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs11_1() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, RDFS.SUBCLASSOF, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource xxx = nt.getSubject();
            Value yyy = nt.getObject();
            if (!(yyy instanceof Resource)) continue;
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements((Resource)yyy, RDFS.SUBCLASSOF, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value zzz = t1.getObject();
                if (!(zzz instanceof Resource) || !(added = this.addInferredStatement(xxx, RDFS.SUBCLASSOF, zzz, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs11_2() throws SailException {
        int nofInferred = 0;
        Iterator ntIter = this.newThisIteration.match(null, RDFS.SUBCLASSOF, null, new Resource[0]);
        while (ntIter.hasNext()) {
            Statement nt = (Statement)ntIter.next();
            Resource yyy = nt.getSubject();
            Value zzz = nt.getObject();
            if (!(zzz instanceof Resource)) continue;
            CloseableIteration t1Iter = this.getWrappedConnection().getStatements(null, RDFS.SUBCLASSOF, (Value)yyy, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                Statement t1 = (Statement)t1Iter.next();
                Resource xxx = t1.getSubject();
                boolean added = this.addInferredStatement(xxx, RDFS.SUBCLASSOF, zzz, new Resource[0]);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs12() throws SailException {
        int nofInferred = 0;
        Iterator iter = this.newThisIteration.match(null, RDF.TYPE, (Value)RDFS.CONTAINERMEMBERSHIPPROPERTY, new Resource[0]);
        while (iter.hasNext()) {
            Statement st = (Statement)iter.next();
            Resource xxx = st.getSubject();
            boolean added = this.addInferredStatement(xxx, RDFS.SUBPROPERTYOF, (Value)RDFS.MEMBER, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs13() throws SailException {
        int nofInferred = 0;
        Iterator iter = this.newThisIteration.match(null, RDF.TYPE, (Value)RDFS.DATATYPE, new Resource[0]);
        while (iter.hasNext()) {
            Statement st = (Statement)iter.next();
            Resource xxx = st.getSubject();
            boolean added = this.addInferredStatement(xxx, RDFS.SUBCLASSOF, (Value)RDFS.LITERAL, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleX1() throws SailException {
        int nofInferred = 0;
        String prefix = "http://www.w3.org/1999/02/22-rdf-syntax-ns#_";
        Iterator iter = this.newThisIteration.match(null, null, null, new Resource[0]);
        while (iter.hasNext()) {
            boolean added;
            Statement st = (Statement)iter.next();
            URI predNode = st.getPredicate();
            String predURI = predNode.toString();
            if (!predURI.startsWith(prefix) || !this.isValidPredicateNumber(predURI.substring(prefix.length())) || !(added = this.addInferredStatement((Resource)predNode, RDF.TYPE, (Value)RDFS.CONTAINERMEMBERSHIPPROPERTY, new Resource[0]))) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private boolean isValidPredicateNumber(String str) {
        int strLength = str.length();
        if (strLength == 0) {
            return false;
        }
        for (int i = 0; i < strLength; ++i) {
            if (ASCIIUtil.isNumber((int)str.charAt(i))) continue;
            return false;
        }
        return str.charAt(0) != '0';
    }
}

