/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import info.aduna.iteration.CloseableIteration;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.Update;
import org.openrdf.query.parser.ParsedBooleanQuery;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.ParsedUpdate;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryReadOnlyException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.base.RepositoryConnectionBase;
import org.openrdf.repository.sail.SailBooleanQuery;
import org.openrdf.repository.sail.SailCloseableIteration;
import org.openrdf.repository.sail.SailGraphQuery;
import org.openrdf.repository.sail.SailQuery;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailTupleQuery;
import org.openrdf.repository.sail.SailUpdate;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.SailReadOnlyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SailRepositoryConnection
extends RepositoryConnectionBase {
    private final SailConnection sailConnection;

    protected SailRepositoryConnection(SailRepository repository, SailConnection sailConnection) {
        super((Repository)repository);
        this.sailConnection = sailConnection;
    }

    public SailConnection getSailConnection() {
        return this.sailConnection;
    }

    public void commit() throws RepositoryException {
        try {
            this.sailConnection.commit();
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void rollback() throws RepositoryException {
        try {
            this.sailConnection.rollback();
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void close() throws RepositoryException {
        try {
            this.sailConnection.close();
            super.close();
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public SailQuery prepareQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedQuery parsedQuery = QueryParserUtil.parseQuery((QueryLanguage)ql, (String)queryString, (String)baseURI);
        if (parsedQuery instanceof ParsedTupleQuery) {
            return new SailTupleQuery((ParsedTupleQuery)parsedQuery, this);
        }
        if (parsedQuery instanceof ParsedGraphQuery) {
            return new SailGraphQuery((ParsedGraphQuery)parsedQuery, this);
        }
        if (parsedQuery instanceof ParsedBooleanQuery) {
            return new SailBooleanQuery((ParsedBooleanQuery)parsedQuery, this);
        }
        throw new RuntimeException("Unexpected query type: " + parsedQuery.getClass());
    }

    public SailTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedTupleQuery parsedQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)ql, (String)queryString, (String)baseURI);
        return new SailTupleQuery(parsedQuery, this);
    }

    public SailGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedGraphQuery parsedQuery = QueryParserUtil.parseGraphQuery((QueryLanguage)ql, (String)queryString, (String)baseURI);
        return new SailGraphQuery(parsedQuery, this);
    }

    public SailBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedBooleanQuery parsedQuery = QueryParserUtil.parseBooleanQuery((QueryLanguage)ql, (String)queryString, (String)baseURI);
        return new SailBooleanQuery(parsedQuery, this);
    }

    public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
        ParsedUpdate parsedUpdate = QueryParserUtil.parseUpdate((QueryLanguage)ql, (String)update, (String)baseURI);
        return new SailUpdate(parsedUpdate, this);
    }

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            return this.createRepositoryResult(this.sailConnection.getContextIDs());
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to get context IDs from Sail", (Throwable)e);
        }
    }

    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        try {
            return this.createRepositoryResult(this.sailConnection.getStatements(subj, pred, obj, includeInferred, contexts));
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to get statements from Sail", (Throwable)e);
        }
    }

    public boolean isEmpty() throws RepositoryException {
        return !this.hasStatement(null, null, null, false, new Resource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        handler.startRDF();
        RepositoryResult<Namespace> nsIter = this.getNamespaces();
        try {
            while (nsIter.hasNext()) {
                Namespace ns = (Namespace)nsIter.next();
                handler.handleNamespace(ns.getPrefix(), ns.getName());
            }
        }
        finally {
            nsIter.close();
        }
        RepositoryResult<Statement> stIter = this.getStatements(subj, pred, obj, includeInferred, contexts);
        try {
            while (stIter.hasNext()) {
                handler.handleStatement((Statement)stIter.next());
            }
        }
        finally {
            stIter.close();
        }
        handler.endRDF();
    }

    public long size(Resource ... contexts) throws RepositoryException {
        try {
            return this.sailConnection.size(contexts);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        try {
            this.sailConnection.addStatement(subject, predicate, object, contexts);
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)e);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        try {
            this.sailConnection.removeStatements(subject, predicate, object, contexts);
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)e);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void autoCommit() throws RepositoryException {
        super.autoCommit();
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        try {
            this.sailConnection.clear(contexts);
            this.autoCommit();
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)e);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        try {
            this.sailConnection.setNamespace(prefix, name);
            this.autoCommit();
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)e);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        try {
            this.sailConnection.removeNamespace(prefix);
            this.autoCommit();
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)e);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void clearNamespaces() throws RepositoryException {
        try {
            this.sailConnection.clearNamespaces();
            this.autoCommit();
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)e);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        try {
            return this.createRepositoryResult(this.sailConnection.getNamespaces());
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to get namespaces from Sail", (Throwable)e);
        }
    }

    public String getNamespace(String prefix) throws RepositoryException {
        try {
            return this.sailConnection.getNamespace(prefix);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected <E> RepositoryResult<E> createRepositoryResult(CloseableIteration<? extends E, SailException> sailIter) {
        return new RepositoryResult(new SailCloseableIteration<E>(sailIter));
    }
}

