/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.setup;

import com.hp.hpl.jena.tdb.base.block.FileMode;
import com.hp.hpl.jena.tdb.index.IndexParams;
import com.hp.hpl.jena.tdb.setup.StoreParamsBuilder;
import org.apache.jena.atlas.lib.StrUtils;

public class StoreParams
implements IndexParams {
    private static StoreParams dftStoreParams = new StoreParamsBuilder().build();
    private final FileMode fileMode;
    private final int blockReadCacheSize;
    private final int blockWriteCacheSize;
    private final int Node2NodeIdCacheSize;
    private final int NodeId2NodeCacheSize;
    private final int NodeMissCacheSize;
    private final int blockSize;
    private final String indexNode2Id;
    private final String indexId2Node;
    private final String primaryIndexTriples;
    private final String[] tripleIndexes;
    private final String primaryIndexQuads;
    private final String[] quadIndexes;
    private final String primaryIndexPrefix;
    private final String[] prefixIndexes;
    private final String indexPrefix;
    private final String prefixNode2Id;
    private final String prefixId2Node;

    public StoreParams(FileMode fileMode, int blockSize, int blockReadCacheSize, int blockWriteCacheSize, int node2NodeIdCacheSize, int nodeId2NodeCacheSize, int nodeMissCacheSize, String indexNode2Id, String indexId2Node, String primaryIndexTriples, String[] tripleIndexes, String primaryIndexQuads, String[] quadIndexes, String primaryIndexPrefix, String[] prefixIndexes, String indexPrefix, String prefixNode2Id, String prefixId2Node) {
        this.fileMode = fileMode;
        this.blockSize = blockSize;
        this.blockReadCacheSize = blockReadCacheSize;
        this.blockWriteCacheSize = blockWriteCacheSize;
        this.Node2NodeIdCacheSize = node2NodeIdCacheSize;
        this.NodeId2NodeCacheSize = nodeId2NodeCacheSize;
        this.NodeMissCacheSize = nodeMissCacheSize;
        this.indexNode2Id = indexNode2Id;
        this.indexId2Node = indexId2Node;
        this.primaryIndexTriples = primaryIndexTriples;
        this.tripleIndexes = tripleIndexes;
        this.primaryIndexQuads = primaryIndexQuads;
        this.quadIndexes = quadIndexes;
        this.primaryIndexPrefix = primaryIndexPrefix;
        this.prefixIndexes = prefixIndexes;
        this.indexPrefix = indexPrefix;
        this.prefixNode2Id = prefixNode2Id;
        this.prefixId2Node = prefixId2Node;
    }

    public static StoreParams getDftStoreParams() {
        return dftStoreParams;
    }

    @Override
    public FileMode getFileMode() {
        return this.fileMode;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int getBlockReadCacheSize() {
        return this.blockReadCacheSize;
    }

    @Override
    public int getBlockWriteCacheSize() {
        return this.blockWriteCacheSize;
    }

    public int getNode2NodeIdCacheSize() {
        return this.Node2NodeIdCacheSize;
    }

    public int getNodeId2NodeCacheSize() {
        return this.NodeId2NodeCacheSize;
    }

    public int getNodeMissCacheSize() {
        return this.NodeMissCacheSize;
    }

    public String getIndexNode2Id() {
        return this.indexNode2Id;
    }

    public String getIndexId2Node() {
        return this.indexId2Node;
    }

    public String getPrimaryIndexTriples() {
        return this.primaryIndexTriples;
    }

    public String[] getTripleIndexes() {
        return this.tripleIndexes;
    }

    public String getPrimaryIndexQuads() {
        return this.primaryIndexQuads;
    }

    public String[] getQuadIndexes() {
        return this.quadIndexes;
    }

    public String getPrimaryIndexPrefix() {
        return this.primaryIndexPrefix;
    }

    public String[] getPrefixIndexes() {
        return this.prefixIndexes;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public String getPrefixNode2Id() {
        return this.prefixNode2Id;
    }

    public String getPrefixId2Node() {
        return this.prefixId2Node;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        this.fmt(buff, "fileMode", this.getFileMode().toString());
        this.fmt(buff, "blockSize", this.getBlockSize());
        this.fmt(buff, "readCacheSize", this.getBlockReadCacheSize());
        this.fmt(buff, "writeCacheSize", this.getBlockWriteCacheSize());
        this.fmt(buff, "Node2NodeIdCacheSize", this.getNode2NodeIdCacheSize());
        this.fmt(buff, "NodeId2NodeCacheSize", this.getNodeId2NodeCacheSize());
        this.fmt(buff, "NodeMissCacheSize", this.getNodeMissCacheSize());
        this.fmt(buff, "indexNode2Id", this.getIndexNode2Id());
        this.fmt(buff, "indexId2Node", this.getIndexId2Node());
        this.fmt(buff, "primaryIndexTriples", this.getPrimaryIndexTriples());
        this.fmt(buff, "tripleIndexes", this.getTripleIndexes());
        this.fmt(buff, "primaryIndexQuads", this.getPrimaryIndexQuads());
        this.fmt(buff, "quadIndexes", this.getQuadIndexes());
        this.fmt(buff, "primaryIndexPrefix", this.getPrimaryIndexPrefix());
        this.fmt(buff, "prefixIndexes", this.getPrefixIndexes());
        this.fmt(buff, "indexPrefix", this.getIndexPrefix());
        this.fmt(buff, "prefixNode2Id", this.getPrefixNode2Id());
        this.fmt(buff, "prefixId2Node", this.getPrefixId2Node());
        return buff.toString();
    }

    private void fmt(StringBuilder buff, String name, String[] strings) {
        buff.append(String.format("%-20s   [%s]\n", name, StrUtils.strjoin((String)", ", (String[])strings)));
    }

    private void fmt(StringBuilder buff, String name, String value) {
        buff.append(String.format("%-20s   %s\n", name, value));
    }

    private void fmt(StringBuilder buff, String name, int value) {
        buff.append(String.format("%-20s   %s\n", name, value));
    }
}

