/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import java.util.Iterator;
import org.apache.jena.atlas.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTableLogger
implements NodeTable {
    private static Logger defaultLogger = LoggerFactory.getLogger(NodeTable.class);
    private final Logger log;
    private final String label;
    private final NodeTable nodeTable;

    public NodeTableLogger(String label, NodeTable nodeTable) {
        this.nodeTable = nodeTable;
        this.label = label;
        this.log = defaultLogger;
    }

    @Override
    public NodeId getAllocateNodeId(Node node) {
        NodeId nId = this.nodeTable.getAllocateNodeId(node);
        this.info("getAllocateNodeId(" + node + ") => " + nId);
        return nId;
    }

    @Override
    public NodeId getNodeIdForNode(Node node) {
        NodeId nId = this.nodeTable.getNodeIdForNode(node);
        this.info("getNodeIdForNode(" + node + ") => " + nId);
        return nId;
    }

    @Override
    public Node getNodeForNodeId(NodeId id) {
        Node n = this.nodeTable.getNodeForNodeId(id);
        this.info("getNodeForNodeId(" + id + ") => " + n);
        return n;
    }

    @Override
    public boolean containsNode(Node node) {
        boolean b = this.nodeTable.containsNode(node);
        this.info("containsNode(" + node + ") => " + b);
        return b;
    }

    @Override
    public boolean containsNodeId(NodeId id) {
        boolean b = this.nodeTable.containsNodeId(id);
        this.info("containsNodeId(" + id + ") => " + b);
        return b;
    }

    @Override
    public NodeId allocOffset() {
        NodeId nodeId = this.nodeTable.allocOffset();
        this.info("allocOffset() => " + nodeId);
        return nodeId;
    }

    @Override
    public Iterator<Pair<NodeId, Node>> all() {
        this.info("all()");
        return this.nodeTable.all();
    }

    @Override
    public boolean isEmpty() {
        boolean b = this.nodeTable.isEmpty();
        this.info("isEmpty() => " + b);
        return b;
    }

    public void sync() {
        this.info("sync()");
        this.nodeTable.sync();
    }

    public void close() {
        this.info("close()");
        this.nodeTable.close();
    }

    private void info(String string) {
        if (this.label != null) {
            string = this.label + ": " + string;
        }
        this.log.info(string);
    }
}

