/*
 * Decompiled with CFR 0.152.
 */
package tdb.tools;

import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.StoreConnection;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.setup.Build;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.sys.Names;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.logging.LogCtl;
import tdb.cmdline.ModLocation;

public class dumpnodetable
extends CmdGeneral {
    ModLocation modLocation = new ModLocation();

    public static void main(String ... argv) {
        LogCtl.setLog4j();
        new dumpnodetable(argv).mainRun();
    }

    protected void exec() {
        List<String> tripleIndexes = Arrays.asList(Names.tripleIndexes);
        List<String> quadIndexes = Arrays.asList(Names.quadIndexes);
        Location loc = this.modLocation.getLocation();
        StoreConnection sConn = StoreConnection.make(loc);
        DatasetGraphTDB dsg = sConn.getBaseDataset();
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        dumpnodetable.dump(System.out, nodeTable);
    }

    protected dumpnodetable(String[] argv) {
        super(argv);
        super.addModule((ArgModuleGeneral)this.modLocation);
    }

    public static void dumpNodes(OutputStream w, String location) {
        dumpnodetable.dump(w, location, "node2id", SystemTDB.Node2NodeIdCacheSize, "nodes", SystemTDB.NodeId2NodeCacheSize, 100);
    }

    public static void dumpPrefixes(OutputStream w, String location) {
        dumpnodetable.dump(w, location, "prefix2id", 100, "prefixes", 100, 10);
    }

    public static void dump(OutputStream w, String location, String indexNode2Id, int node2NodeIdCacheSize, String indexId2Node, int nodeId2NodeCacheSize, int sizeNodeMissCacheSize) {
        NodeTable nodeTable = Build.makeNodeTable(new Location(location), indexNode2Id, node2NodeIdCacheSize, indexId2Node, nodeId2NodeCacheSize, sizeNodeMissCacheSize);
    }

    public static void dump(OutputStream w, NodeTable nodeTable) {
        Iterator<Pair<NodeId, Node>> iter = nodeTable.all();
        long count = 0L;
        try (IndentedWriter iw = new IndentedWriter(w);){
            while (iter.hasNext()) {
                Pair<NodeId, Node> pair = iter.next();
                iw.print(((NodeId)pair.car()).toString());
                iw.print(" : ");
                Node n = (Node)pair.cdr();
                String $ = dumpnodetable.stringForNode(n);
                iw.print($);
                iw.println();
                ++count;
            }
            iw.println();
            iw.printf("Total: " + count, new Object[0]);
            iw.println();
            iw.flush();
        }
    }

    private static String stringForNode(Node n) {
        if (n == null) {
            return "<<null>>";
        }
        if (n.isBlank()) {
            return "_:" + n.getBlankNodeLabel();
        }
        if (n.isLiteral()) {
            return dumpnodetable.stringForLiteral((Node_Literal)n);
        }
        if (n.isURI()) {
            String uri = n.getURI();
            return dumpnodetable.stringForURI(uri);
        }
        if (n.isVariable()) {
            return "?" + n.getName();
        }
        if (n.equals((Object)Node.ANY)) {
            return "ANY";
        }
        Log.warn(FmtUtils.class, (String)("Failed to turn a node into a string: " + n));
        return n.toString();
    }

    public static String stringForURI(String uri) {
        return "<" + uri + ">";
    }

    public static String stringForLiteral(Node_Literal literal) {
        String datatype = literal.getLiteralDatatypeURI();
        String lang = literal.getLiteralLanguage();
        String s = literal.getLiteralLexicalForm();
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("\"");
        FmtUtils.stringEsc((StringBuilder)sbuff, (String)s, (boolean)true);
        sbuff.append("\"");
        if (lang != null && lang.length() > 0) {
            sbuff.append("@");
            sbuff.append(lang);
        }
        if (datatype != null) {
            sbuff.append("^^");
            sbuff.append(dumpnodetable.stringForURI(datatype));
        }
        return sbuff.toString();
    }

    protected void processModulesAndArgs() {
        if (this.modVersion.getVersionFlag()) {
            this.modVersion.printVersionAndExit();
        }
        if (this.modLocation.getLocation() == null) {
            this.cmdError("Location required");
        }
    }

    protected String getSummary() {
        return this.getCommandName() + " --loc=DIR IndexName";
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }
}

