/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

import com.hp.hpl.jena.sparql.util.Convert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Params {
    private List<Pair> paramList = new ArrayList<Pair>();
    private Map<String, List<String>> params = new HashMap<String, List<String>>();

    public Params() {
    }

    public Params(Params other) {
        this.merge(other);
    }

    public void merge(Params other) {
        this.params.putAll(other.params);
        this.paramList.addAll(other.paramList);
    }

    public void addParam(String name, String value) {
        Pair p = new Pair(name, value);
        this.paramList.add(p);
        List<String> x = this.params.get(name);
        if (x == null) {
            x = new ArrayList<String>();
            this.params.put(name, x);
        }
        x.add(value);
    }

    public void addParam(String name) {
        this.addParam(name, null);
    }

    public boolean containsParam(String name) {
        return this.params.containsKey(name);
    }

    public String getValue(String name) {
        List<String> x = this.getMV(name);
        if (x == null) {
            return null;
        }
        if (x.size() != 1) {
            throw new MultiValueException("Multiple value (" + x.size() + " when exactly one requested");
        }
        return x.get(0);
    }

    public List<String> getValues(String name) {
        return this.getMV(name);
    }

    public void remove(String name) {
        Iterator<Pair> iter = this.paramList.iterator();
        while (iter.hasNext()) {
            Pair p = iter.next();
            if (!p.getName().equals(name)) continue;
            iter.remove();
        }
        this.params.remove(name);
    }

    public List<Pair> pairs() {
        return this.paramList;
    }

    public int count() {
        return this.paramList.size();
    }

    public List<String> names() {
        ArrayList<String> names = new ArrayList<String>();
        for (Pair pair : this.paramList) {
            String s = pair.getName();
            if (names.contains(s)) continue;
            names.add(s);
        }
        return names;
    }

    public String httpString() {
        StringBuilder sbuff = new StringBuilder();
        boolean first = true;
        for (Pair p : this.pairs()) {
            if (!first) {
                sbuff.append('&');
            }
            sbuff.append(p.getName());
            sbuff.append('=');
            String x = p.getValue();
            x = Convert.encWWWForm(x);
            sbuff.append(x);
            first = false;
        }
        return sbuff.toString();
    }

    private List<String> getMV(String name) {
        return this.params.get(name);
    }

    public static class Pair {
        String name;
        String value;

        Pair(String name, String value) {
            this.setName(name);
            this.setValue(value);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        void setName(String name) {
            this.name = name;
        }

        void setValue(String value) {
            this.value = value;
        }
    }

    static class MultiValueException
    extends RuntimeException {
        MultiValueException(String msg) {
            super(msg);
        }
    }
}

