/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModDataset;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.core.DataFormat;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.util.DatasetUtils;
import java.util.List;
import org.apache.jena.riot.RDFDataMgr;

public class ModDatasetGeneral
extends ModDataset {
    protected final ArgDecl graphDecl = new ArgDecl(true, "graph", new String[0]);
    protected final ArgDecl dataDecl = new ArgDecl(true, "data", new String[0]);
    protected final ArgDecl namedGraphDecl = new ArgDecl(true, "named", "namedgraph", "namedGraph", "namedData", "nameddata");
    private List<String> dataURLs = null;
    private List<String> graphURLs = null;
    private List<String> namedGraphURLs = null;
    private DataFormat dataSyntax = null;

    protected ModDatasetGeneral() {
    }

    @Override
    public void registerWith(CmdGeneral cl) {
        cl.getUsage().startCategory("Dataset");
        cl.add(this.dataDecl, "--data=FILE", "Data for the datset - triple or quad formats");
        cl.add(this.graphDecl, "--graph=FILE", "Graph for default graph of the datset");
        cl.add(this.namedGraphDecl, "--namedGraph=FILE", "Add a graph into the dataset as a named graph");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        this.dataURLs = cmdLine.getValues(this.dataDecl);
        this.graphURLs = cmdLine.getValues(this.graphDecl);
        this.namedGraphURLs = cmdLine.getValues(this.namedGraphDecl);
    }

    @Override
    public Dataset createDataset() {
        if (!(this.dataURLs != null && this.dataURLs.size() != 0 || this.graphURLs != null && this.graphURLs.size() != 0 || this.namedGraphURLs != null && this.namedGraphURLs.size() != 0)) {
            return null;
        }
        DatasetGraph dsg = DatasetGraphFactory.createMem();
        Dataset ds = DatasetFactory.create(dsg);
        this.addGraphs(ds);
        this.dataset = ds;
        return this.dataset;
    }

    protected void addGraphs(Dataset ds) {
        try {
            if (this.dataURLs != null) {
                for (String url : this.dataURLs) {
                    RDFDataMgr.read(ds, url);
                }
            }
            if (this.graphURLs != null || this.namedGraphURLs != null) {
                ds = DatasetUtils.addInGraphs(ds, this.graphURLs, this.namedGraphURLs, null);
            }
        }
        catch (LabelExistsException ex) {
            throw new CmdException(ex.getMessage());
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Error creating dataset", ex);
        }
    }

    public List<String> getGraphURLs() {
        return this.graphURLs;
    }

    public List<String> getNamedGraphURLs() {
        return this.namedGraphURLs;
    }
}

