/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import java.util.HashSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.StreamRDFWriter;

public class ModLangOutput
implements ArgModuleGeneral {
    protected ArgDecl argOutput = new ArgDecl(true, "out", "output");
    private RDFFormat format = RDFFormat.NQUADS;

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Output control");
        cmdLine.add(this.argOutput, "--out=FMT", "Output in the given format");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.argOutput)) {
            String langName = cmdLine.getValue(this.argOutput);
            Lang output = RDFLanguages.nameToLang(langName);
            if (output == null) {
                throw new CmdException("Not recognized as an RDF language : '" + langName + "'");
            }
            if (!StreamRDFWriter.registered(output)) {
                HashSet<Lang> seen = new HashSet<Lang>();
                for (RDFFormat fmt : StreamRDFWriter.registered()) {
                    if (seen.contains(fmt.getLang())) continue;
                    seen.add(fmt.getLang());
                    System.err.println("   " + fmt.getLang().getLabel());
                }
                throw new CmdException("Not recognized as an streaming RDF language : '" + langName + "'");
            }
            this.format = StreamRDFWriter.defaultSerialization(output);
        }
    }

    public RDFFormat getOutputFormat() {
        return this.format;
    }
}

