/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;

public class LiteralImpl
implements Literal {
    private static final long serialVersionUID = -1649571784782592271L;
    private String label;
    private String language;
    private URI datatype;

    protected LiteralImpl() {
    }

    public LiteralImpl(String label) {
        this(label, null, null);
    }

    public LiteralImpl(String label, String language) {
        this(label, language, null);
    }

    public LiteralImpl(String label, URI datatype) {
        this(label, null, datatype);
    }

    private LiteralImpl(String label, String language, URI datatype) {
        assert (label != null);
        this.setLabel(label);
        if (language != null) {
            this.setLanguage(language.toLowerCase());
        }
        if (datatype != null) {
            this.setDatatype(datatype);
        }
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    protected void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    protected void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    public URI getDatatype() {
        return this.datatype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Literal) {
            Literal other = (Literal)o;
            if (!this.label.equals(other.getLabel())) {
                return false;
            }
            if (this.datatype == null ? other.getDatatype() != null : !this.datatype.equals(other.getDatatype())) {
                return false;
            }
            return !(this.language == null ? other.getLanguage() != null : !this.language.equals(other.getLanguage()));
        }
        return false;
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.label.length() * 2);
        sb.append('\"');
        sb.append(this.label);
        sb.append('\"');
        if (this.language != null) {
            sb.append('@');
            sb.append(this.language);
        }
        if (this.datatype != null) {
            sb.append("^^<");
            sb.append(this.datatype.toString());
            sb.append(">");
        }
        return sb.toString();
    }

    public String stringValue() {
        return this.label;
    }

    public boolean booleanValue() {
        return XMLDatatypeUtil.parseBoolean(this.getLabel());
    }

    public byte byteValue() {
        return XMLDatatypeUtil.parseByte(this.getLabel());
    }

    public short shortValue() {
        return XMLDatatypeUtil.parseShort(this.getLabel());
    }

    public int intValue() {
        return XMLDatatypeUtil.parseInt(this.getLabel());
    }

    public long longValue() {
        return XMLDatatypeUtil.parseLong(this.getLabel());
    }

    public float floatValue() {
        return XMLDatatypeUtil.parseFloat(this.getLabel());
    }

    public double doubleValue() {
        return XMLDatatypeUtil.parseDouble(this.getLabel());
    }

    public BigInteger integerValue() {
        return XMLDatatypeUtil.parseInteger(this.getLabel());
    }

    public BigDecimal decimalValue() {
        return XMLDatatypeUtil.parseDecimal(this.getLabel());
    }

    public XMLGregorianCalendar calendarValue() {
        return XMLDatatypeUtil.parseCalendar(this.getLabel());
    }
}

