/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.setup;

import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.setup.DatasetBuilderStd;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.setup.StoreParamsBuilder;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndex;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndexRecord;
import com.hp.hpl.jena.tdb.sys.DatasetControl;
import org.apache.jena.atlas.lib.ColumnMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Build {
    private static boolean VERBOSE = true;
    private static Logger log = LoggerFactory.getLogger(Build.class);
    private static StoreParams params = StoreParams.getDftStoreParams();

    public static TupleIndex openTupleIndex(Location location, String indexName, String primary, String indexOrder, int readCacheSize, int writeCacheSize, int dftKeyLength, int dftValueLength) {
        StoreParamsBuilder spb = new StoreParamsBuilder();
        spb.blockReadCacheSize(readCacheSize);
        spb.blockWriteCacheSize(writeCacheSize);
        RecordFactory recordFactory = new RecordFactory(dftKeyLength, dftValueLength);
        StoreParams idxParams = spb.build();
        FileSet fs = new FileSet(location, indexName);
        RangeIndex rIndex = IndexFactory.buildRangeIndex(fs, recordFactory, idxParams);
        TupleIndexRecord tupleIndex = new TupleIndexRecord(primary.length(), new ColumnMap(primary, indexOrder), indexOrder, rIndex.getRecordFactory(), rIndex);
        return tupleIndex;
    }

    public static DatasetPrefixesTDB makePrefixes(Location location, DatasetControl policy) {
        return DatasetBuilderStd.stdBuilder().makePrefixTable(location, policy, params);
    }

    public static NodeTable makeNodeTable(Location location) {
        return Build.makeNodeTable(location, params);
    }

    public static NodeTable makeNodeTable(Location location, StoreParams params) {
        DatasetBuilderStd dbBuild = DatasetBuilderStd.stdBuilder();
        return dbBuild.makeNodeTable(location, params);
    }

    public static NodeTable makeNodeTable(Location location, String indexNode2Id, int node2NodeIdCacheSize, String indexId2Node, int nodeId2NodeCacheSize, int sizeNodeMissCacheSize) {
        StoreParamsBuilder spb = new StoreParamsBuilder();
        spb.indexNode2Id(indexNode2Id).node2NodeIdCacheSize(node2NodeIdCacheSize);
        spb.indexId2Node(indexId2Node).nodeId2NodeCacheSize(nodeId2NodeCacheSize);
        DatasetBuilderStd dbBuild = DatasetBuilderStd.stdBuilder();
        return Build.makeNodeTable(location, spb.build());
    }
}

