/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.contextaware;

import org.openrdf.model.URI;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryWrapper;
import org.openrdf.repository.contextaware.ContextAwareConnection;

public class ContextAwareRepository
extends RepositoryWrapper {
    private static final URI[] ALL_CONTEXTS = new URI[0];
    private boolean includeInferred = true;
    private int maxQueryTime;
    private QueryLanguage ql = QueryLanguage.SPARQL;
    private String baseURI;
    private URI[] readContexts = ALL_CONTEXTS;
    private URI[] addContexts = ALL_CONTEXTS;
    private URI[] removeContexts = ALL_CONTEXTS;
    private URI[] archiveContexts = ALL_CONTEXTS;
    private URI insertContext = null;

    public ContextAwareRepository() {
    }

    public ContextAwareRepository(Repository delegate) {
        super(delegate);
    }

    public int getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(int maxQueryTime) {
        this.maxQueryTime = maxQueryTime;
    }

    @Deprecated
    public URI[] getAddContexts() {
        return this.addContexts;
    }

    @Deprecated
    public URI[] getArchiveContexts() {
        return this.archiveContexts;
    }

    public URI getInsertContext() {
        return this.insertContext;
    }

    public QueryLanguage getQueryLanguage() {
        return this.ql;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public URI[] getReadContexts() {
        return this.readContexts;
    }

    public URI[] getRemoveContexts() {
        return this.removeContexts;
    }

    public boolean isIncludeInferred() {
        return this.includeInferred;
    }

    @Deprecated
    public void setAddContexts(URI ... addContexts) {
        this.addContexts = addContexts;
    }

    @Deprecated
    public void setArchiveContexts(URI ... archiveContexts) {
        this.archiveContexts = archiveContexts;
    }

    public void setInsertContext(URI insertContext) {
        this.insertContext = insertContext;
    }

    public void setIncludeInferred(boolean includeInferred) {
        this.includeInferred = includeInferred;
    }

    public void setQueryLanguage(QueryLanguage ql) {
        this.ql = ql;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public void setReadContexts(URI ... readContexts) {
        this.readContexts = readContexts;
    }

    public void setRemoveContexts(URI ... removeContexts) {
        this.removeContexts = removeContexts;
    }

    public ContextAwareConnection getConnection() throws RepositoryException {
        ContextAwareConnection con = new ContextAwareConnection((Repository)this, super.getConnection());
        con.setIncludeInferred(this.isIncludeInferred());
        con.setMaxQueryTime(this.getMaxQueryTime());
        con.setQueryLanguage(this.getQueryLanguage());
        con.setBaseURI(this.getBaseURI());
        con.setReadContexts(this.getReadContexts());
        con.setAddContexts(this.getAddContexts());
        con.setRemoveContexts(this.getRemoveContexts());
        con.setArchiveContexts(this.getArchiveContexts());
        con.setInsertContext(this.getInsertContext());
        return con;
    }
}

