/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.CloseableIterationBase;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelayedIteration<E, X extends Exception>
extends CloseableIterationBase<E, X> {
    private Iteration<? extends E, ? extends X> iter;

    protected abstract Iteration<? extends E, ? extends X> createIteration() throws X;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() throws X {
        if (this.iter == null) {
            DelayedIteration delayedIteration = this;
            synchronized (delayedIteration) {
                block5: {
                    if (!this.isClosed()) break block5;
                    return false;
                }
                this.iter = this.createIteration();
            }
        }
        return this.iter.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() throws X {
        if (this.iter == null) {
            DelayedIteration delayedIteration = this;
            synchronized (delayedIteration) {
                if (this.isClosed()) {
                    throw new NoSuchElementException("Iteration has been closed");
                }
                this.iter = this.createIteration();
            }
        }
        return this.iter.next();
    }

    @Override
    public void remove() throws X {
        if (this.iter == null || this.isClosed()) {
            throw new IllegalStateException();
        }
        this.iter.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() throws X {
        super.handleClose();
        DelayedIteration delayedIteration = this;
        synchronized (delayedIteration) {
            Iterations.closeCloseable(this.iter);
        }
    }
}

