/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.dawg;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.dawg.DAWGTestResultSetSchema;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class DAWGTestBooleanParser
extends RDFHandlerBase {
    private Graph graph = new GraphImpl();
    private boolean value;

    public boolean getValue() {
        return this.value;
    }

    public void startRDF() throws RDFHandlerException {
        this.graph.clear();
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.graph.add((Object)st);
    }

    public void endRDF() throws RDFHandlerException {
        block4: {
            try {
                Resource resultSetNode = GraphUtil.getUniqueSubject((Graph)this.graph, (URI)RDF.TYPE, (Value)DAWGTestResultSetSchema.RESULTSET, (Resource[])new Resource[0]);
                Literal booleanLit = GraphUtil.getUniqueObjectLiteral((Graph)this.graph, (Resource)resultSetNode, (URI)DAWGTestResultSetSchema.BOOLEAN);
                if (booleanLit.equals((Object)DAWGTestResultSetSchema.TRUE)) {
                    this.value = true;
                    break block4;
                }
                if (booleanLit.equals((Object)DAWGTestResultSetSchema.FALSE)) {
                    this.value = false;
                    break block4;
                }
                throw new RDFHandlerException("Invalid boolean value: " + booleanLit);
            }
            catch (GraphUtilException e) {
                throw new RDFHandlerException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

