/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.HashSet;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingSetAssignment
extends QueryModelNodeBase
implements TupleExpr {
    private Iterable<BindingSet> bindingSets;

    @Override
    public Set<String> getBindingNames() {
        return this.getAssuredBindingNames();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.bindingSets != null) {
            for (BindingSet set : this.bindingSets) {
                result.addAll(set.getBindingNames());
            }
        }
        return result;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof BindingSetAssignment;
    }

    public int hashCode() {
        return "BindingSetAssignment".hashCode();
    }

    @Override
    public BindingSetAssignment clone() {
        return (BindingSetAssignment)super.clone();
    }

    public void setBindingSets(Iterable<BindingSet> bindingSets) {
        this.bindingSets = bindingSets;
    }

    public Iterable<BindingSet> getBindingSets() {
        return this.bindingSets;
    }

    @Override
    public String getSignature() {
        String signature = super.getSignature();
        signature = String.valueOf(signature) + " (" + this.getBindingSets().toString() + ")";
        return signature;
    }
}

