/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.ValueExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NAryValueOperator
extends QueryModelNodeBase
implements ValueExpr {
    protected List<ValueExpr> args;

    public NAryValueOperator() {
    }

    public NAryValueOperator(List<ValueExpr> args) {
        this.setArguments(args);
    }

    public void setArguments(List<ValueExpr> args) {
        this.args = args;
    }

    public List<ValueExpr> getArguments() {
        return this.args;
    }

    public void addArgument(ValueExpr arg) {
        if (this.args == null) {
            this.args = new ArrayList<ValueExpr>();
        }
        this.args.add(arg);
        arg.setParentNode(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ValueExpr arg : this.args) {
            arg.visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        boolean replaced = false;
        int i = 0;
        while (i < this.args.size()) {
            ValueExpr arg = this.args.get(i);
            if (arg == current) {
                this.args.remove(i);
                this.args.add(i, (ValueExpr)replacement);
                replaced = true;
            }
            ++i;
        }
        if (!replaced) {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof NAryValueOperator) {
            NAryValueOperator o = (NAryValueOperator)other;
            return this.getArguments().equals(o.getArguments());
        }
        return false;
    }

    public int hashCode() {
        return this.getArguments().hashCode();
    }

    @Override
    public NAryValueOperator clone() {
        NAryValueOperator clone = (NAryValueOperator)super.clone();
        clone.setArguments(new ArrayList<ValueExpr>());
        for (ValueExpr arg : this.getArguments()) {
            clone.addArgument(arg.clone());
        }
        return clone;
    }
}

