/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.helpers;

import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryModelTreePrinter
extends QueryModelVisitorBase<RuntimeException> {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String indentString = "   ";
    private StringBuilder buf = new StringBuilder(256);
    private int indentLevel = 0;

    public static String printTree(QueryModelNode node) {
        QueryModelTreePrinter treePrinter = new QueryModelTreePrinter();
        node.visit(treePrinter);
        return treePrinter.getTreeString();
    }

    public String getTreeString() {
        return this.buf.toString();
    }

    @Override
    protected void meetNode(QueryModelNode node) {
        int i = 0;
        while (i < this.indentLevel) {
            this.buf.append(this.indentString);
            ++i;
        }
        this.buf.append(node.getSignature());
        this.buf.append(LINE_SEPARATOR);
        ++this.indentLevel;
        super.meetNode(node);
        --this.indentLevel;
    }
}

