/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Join
extends BinaryTupleOperator {
    public Join() {
    }

    public Join(TupleExpr leftArg, TupleExpr rightArg) {
        super(leftArg, rightArg);
    }

    public boolean hasSubSelectInRightArg() {
        return this.containsProjection(this.rightArg);
    }

    @Override
    public Set<String> getBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(16);
        bindingNames.addAll(this.getLeftArg().getBindingNames());
        bindingNames.addAll(this.getRightArg().getBindingNames());
        return bindingNames;
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(16);
        bindingNames.addAll(this.getLeftArg().getAssuredBindingNames());
        bindingNames.addAll(this.getRightArg().getAssuredBindingNames());
        return bindingNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Join && super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ "Join".hashCode();
    }

    @Override
    public Join clone() {
        return (Join)super.clone();
    }

    private boolean containsProjection(TupleExpr t) {
        class VisitException
        extends Exception {
            VisitException() {
            }
        }
        final boolean[] result = new boolean[1];
        try {
            t.visit(new QueryModelVisitorBase<VisitException>(){

                @Override
                public void meet(Projection node) throws VisitException {
                    result[0] = true;
                    throw new VisitException();
                }

                @Override
                public void meet(Join node) throws VisitException {
                    result[0] = false;
                    throw new VisitException();
                }
            });
        }
        catch (VisitException visitException) {
            // empty catch block
        }
        return result[0];
    }
}

