/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service
extends UnaryTupleOperator {
    private Var serviceRef;
    private String serviceExpressionString;
    private Set<String> serviceVars;
    private Map<String, String> prefixDeclarations;
    private String baseURI;
    private String preparedSelectQueryString;
    private String preparedAskQueryString;
    private boolean silent;
    private static Pattern subselectPattern = Pattern.compile("SELECT.*", 34);

    public Service(Var serviceRef, TupleExpr serviceExpr, String serviceExpressionString, Map<String, String> prefixDeclarations, String baseURI, boolean silent) {
        super(serviceExpr);
        this.setServiceRef(serviceRef);
        this.setExpressionString(serviceExpressionString);
        this.serviceVars = this.computeServiceVars(serviceExpr);
        this.setPrefixDeclarations(prefixDeclarations);
        this.setBaseURI(baseURI);
        this.initPreparedQueryString();
        this.silent = silent;
    }

    public Var getServiceRef() {
        return this.serviceRef;
    }

    public TupleExpr getServiceExpr() {
        return this.arg;
    }

    public void setServiceRef(Var serviceRef) {
        this.serviceRef = serviceRef;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public Map<String, String> getPrefixDeclarations() {
        return this.prefixDeclarations;
    }

    public void setPrefixDeclarations(Map<String, String> prefixDeclarations) {
        this.prefixDeclarations = prefixDeclarations;
    }

    public void setExpressionString(String serviceExpressionString) {
        this.serviceExpressionString = this.parseServiceExpression(serviceExpressionString);
    }

    public String getServiceExpressionString() {
        return this.serviceExpressionString;
    }

    public String getQueryString(Set<String> projectionVars) {
        if (projectionVars.size() == 0) {
            return this.preparedAskQueryString;
        }
        StringBuilder sb = new StringBuilder();
        for (String var : projectionVars) {
            sb.append(" ?").append(var);
        }
        return this.preparedSelectQueryString.replace("%PROJECTION_VARS%", sb.toString());
    }

    public Set<String> getServiceVars() {
        return this.serviceVars;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.serviceRef.visit(visitor);
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.serviceRef == current) {
            this.setServiceRef((Var)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Service && super.equals(other)) {
            Service o = (Service)other;
            return this.serviceRef.equals(o.getServiceRef());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.serviceRef.hashCode();
    }

    @Override
    public Service clone() {
        Service clone = (Service)super.clone();
        clone.setServiceRef(this.serviceRef.clone());
        return clone;
    }

    private Set<String> computeServiceVars(TupleExpr serviceExpression) {
        final HashSet<String> res = new HashSet<String>();
        serviceExpression.visit(new QueryModelVisitorBase<RuntimeException>(){

            @Override
            public void meet(Var node) throws RuntimeException {
                if (!node.hasValue() && !node.isAnonymous()) {
                    res.add(node.getName());
                }
            }
        });
        return res;
    }

    private void initPreparedQueryString() {
        this.serviceExpressionString = this.serviceExpressionString.trim();
        String prefixString = this.computePrefixString(this.prefixDeclarations);
        StringBuilder sb = new StringBuilder();
        sb.append(prefixString);
        if (subselectPattern.matcher(this.serviceExpressionString).matches()) {
            sb.append(this.serviceExpressionString);
        } else {
            sb.append("SELECT %PROJECTION_VARS% WHERE { ");
            sb.append(this.serviceExpressionString);
            sb.append(" }");
        }
        this.preparedSelectQueryString = sb.toString();
        sb = new StringBuilder();
        sb.append(prefixString);
        sb.append("ASK {");
        sb.append(this.serviceExpressionString);
        sb.append(" }");
        this.preparedAskQueryString = sb.toString();
    }

    private String computePrefixString(Map<String, String> prefixDeclarations) {
        if (prefixDeclarations == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String prefix : prefixDeclarations.keySet()) {
            String uri = prefixDeclarations.get(prefix);
            sb.append("PREFIX ").append(prefix).append(":").append(" <").append(uri).append("> ");
        }
        return sb.toString();
    }

    private String parseServiceExpression(String serviceExpression) {
        if (serviceExpression.toLowerCase().startsWith("service")) {
            return serviceExpression.substring(serviceExpression.indexOf("{") + 1, serviceExpression.lastIndexOf("}")).trim();
        }
        return serviceExpression;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }
}

