/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.antidot.semantic.rdf.rdb2rdf.main;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.antidot.semantic.rdf.model.impl.sesame.SesameDataSet;
import net.antidot.semantic.rdf.rdb2rdf.dm.core.DirectMapper;
import net.antidot.semantic.rdf.rdb2rdf.dm.core.DirectMappingEngine.Version;
import net.antidot.semantic.rdf.rdb2rdf.r2rml.core.R2RMLProcessor;
import net.antidot.sql.model.core.DriverType;
import net.antidot.sql.model.core.SQLConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openrdf.rio.RDFFormat;

/**
 *
 * @author Kathrin
 */
public class Visual_Class extends javax.swing.JFrame {

    private static Log log = LogFactory.getLog(Db2triples.class);
    private static Visual_Class vista;

    public static Visual_Class getInterface() {
        if (vista == null) {
            vista = new Visual_Class();
        }
        return vista;
    }
    private DriverType driver = DriverType.PostgreSQL;
    private String url;
    private Connection conn;
    private Thread thread;

    /**
     * Creates new form Vista
     */
    private Visual_Class() {
        initComponents();
        connectB.setEnabled(false);
        validateInterface();
        File f = new File(System.getProperty("user.home") + File.separator + "outputDB2Triple");
        if (!f.exists()) {
            f.mkdir();
        }
        File f1 = new File(f, "nativeStore");
        if (!f1.exists()) {
            f1.mkdir();
        }
        outputR2B2.setEnabled(false);
        nativeStore.setText(f1.getAbsolutePath());
        output.setText(f + File.separator + "output.rdf");
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        server = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        port = new javax.swing.JSpinner();
        jLabel3 = new javax.swing.JLabel();
        user = new javax.swing.JTextField();
        labelpass = new javax.swing.JLabel();
        pass = new javax.swing.JPasswordField();
        jLabel5 = new javax.swing.JLabel();
        dbname = new javax.swing.JTextField();
        connectB = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        jComboBox1 = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        mode = new javax.swing.JComboBox();
        startB = new javax.swing.JButton();
        jLabel7 = new javax.swing.JLabel();
        output = new javax.swing.JTextField();
        outputB = new javax.swing.JButton();
        jLabel8 = new javax.swing.JLabel();
        urlT = new javax.swing.JTextField();
        nativeStore = new javax.swing.JTextField();
        outputNSB1 = new javax.swing.JButton();
        jCheckBox1 = new javax.swing.JCheckBox();
        jLabel12 = new javax.swing.JLabel();
        r2rmlFile = new javax.swing.JTextField();
        outputR2B2 = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        currentTable = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        tuplesNumber = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        currentTuple = new javax.swing.JLabel();
        progress = new javax.swing.JProgressBar();
        time = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Vista DB2Triple");
        setResizable(false);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Connection"));

        jLabel1.setText("Server");

        server.setText("localhost");
        server.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                serverKeyReleased(evt);
            }
        });

        jLabel2.setText("Port");

        port.setValue(new Integer(5432));

        jLabel3.setText("User");

        user.setText("postgres");
        user.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                userKeyReleased(evt);
            }
        });

        labelpass.setText("Password");

        pass.setText("root");
        pass.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                passKeyReleased(evt);
            }
        });

        jLabel5.setText("Database Name");

        dbname.setText("Web_Semantica");
        dbname.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dbnameActionPerformed(evt);
            }
        });
        dbname.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                dbnameKeyReleased(evt);
            }
        });

        connectB.setText("Connect");
        connectB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                connectBActionPerformed(evt);
            }
        });

        jLabel6.setText("Server Type");

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "PostgreSQL", "MySQL" }));
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addGroup(jPanel1Layout.createSequentialGroup()
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(server)
                                .addGroup(jPanel1Layout.createSequentialGroup()
                                    .addComponent(jLabel1)
                                    .addGap(0, 0, Short.MAX_VALUE)))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(port, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(jLabel2))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(dbname, javax.swing.GroupLayout.PREFERRED_SIZE, 114, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(jLabel5)))
                        .addGroup(jPanel1Layout.createSequentialGroup()
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(jPanel1Layout.createSequentialGroup()
                                    .addGap(2, 2, 2)
                                    .addComponent(jLabel3))
                                .addComponent(user, javax.swing.GroupLayout.PREFERRED_SIZE, 107, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(labelpass)
                                .addGroup(jPanel1Layout.createSequentialGroup()
                                    .addComponent(pass, javax.swing.GroupLayout.PREFERRED_SIZE, 108, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(connectB)))))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, 131, javax.swing.GroupLayout.PREFERRED_SIZE))))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap(14, Short.MAX_VALUE)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel2)
                            .addComponent(jLabel5)
                            .addComponent(jLabel1))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(dbname, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(server, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(port, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(labelpass))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(user, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(pass, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(connectB))
                .addContainerGap())
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Configuration"));

        jLabel4.setText("Mode");

        mode.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Direct Mapping", "R2RML" }));
        mode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                modeActionPerformed(evt);
            }
        });

        startB.setText("Start");
        startB.setEnabled(false);
        startB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startBActionPerformed(evt);
            }
        });

        jLabel7.setText("Output");

        output.setEditable(false);

        outputB.setText("...");
        outputB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                outputBActionPerformed(evt);
            }
        });

        jLabel8.setText("URL");

        urlT.setText("http://data.kdd.com/");

        nativeStore.setEditable(false);

        outputNSB1.setText("...");
        outputNSB1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                outputNSB1ActionPerformed(evt);
            }
        });

        jCheckBox1.setSelected(true);
        jCheckBox1.setText("Native Store Directory");
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        jLabel12.setText("R2rml File");

        r2rmlFile.setEditable(false);
        r2rmlFile.setText("C:\\Users\\Kathrin\\Desktop\\Monografia_INF2891\\Author_r2rmlMapping.n3");

        outputR2B2.setText("...");
        outputR2B2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                outputR2B2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(output)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(outputB))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(mode, 0, 194, Short.MAX_VALUE)
                            .addComponent(jLabel7)
                            .addComponent(jLabel4))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addComponent(jLabel8)
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addComponent(urlT, javax.swing.GroupLayout.DEFAULT_SIZE, 216, Short.MAX_VALUE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(startB, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jCheckBox1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nativeStore)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(outputNSB1))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(r2rmlFile, javax.swing.GroupLayout.DEFAULT_SIZE, 373, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(outputR2B2))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel12)
                        .addGap(226, 226, 226)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(jLabel8))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(mode, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(urlT, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel7)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(output, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(outputB))
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(27, 27, 27)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(nativeStore, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(outputNSB1))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jCheckBox1)
                        .addGap(18, 18, 18)))
                .addComponent(jLabel12)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(r2rmlFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(outputR2B2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(startB)
                .addGap(12, 12, 12))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Output"));

        jLabel9.setText("Current Table:");

        currentTable.setText(" ");

        jLabel10.setText("Tuples:");

        tuplesNumber.setText(" ");

        jLabel11.setText("Current Tuple:");

        currentTuple.setText(" ");

        progress.setStringPainted(true);

        time.setText(" ");

        jLabel13.setText("Time:");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addComponent(jLabel9)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(currentTable, javax.swing.GroupLayout.PREFERRED_SIZE, 168, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jLabel10)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tuplesNumber, javax.swing.GroupLayout.PREFERRED_SIZE, 119, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jLabel11)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(currentTuple, javax.swing.GroupLayout.PREFERRED_SIZE, 142, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 114, Short.MAX_VALUE))
            .addComponent(progress, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addGap(0, 0, Short.MAX_VALUE)
                .addComponent(jLabel13)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(time, javax.swing.GroupLayout.PREFERRED_SIZE, 140, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel9)
                    .addComponent(currentTable)
                    .addComponent(jLabel10)
                    .addComponent(tuplesNumber)
                    .addComponent(jLabel11)
                    .addComponent(currentTuple))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(progress, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(time)
                    .addComponent(jLabel13)))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void connectBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_connectBActionPerformed
        try {
            // TODO add your handling code here:
            if (connectB.getText().equalsIgnoreCase("connect")) {
                if (jComboBox1.getSelectedItem().toString().equalsIgnoreCase("postgresql")) {
                    url = "jdbc:postgresql://" + server.getText() + "/";
                } else {
                    url = "jdbc:mysql://" + server.getText() + "/";
                }
                String userName = user.getText();
                String password = pass.getText();
                String dbName = dbname.getText();
                conn = SQLConnector.connect(userName, password, url + dbName, driver);
                connectB.setText("Desconnect");
                jComboBox1.setEnabled(false);
                server.setEnabled(false);
                port.setEnabled(false);
                dbname.setEnabled(false);
                user.setEnabled(false);
                pass.setEnabled(false);
                validateStart();
                JOptionPane.showMessageDialog(rootPane, "Connection successful.");
            } else {
                connectB.setText("Connect");
                jComboBox1.setEnabled(true);
                server.setEnabled(true);
                port.setEnabled(true);
                dbname.setEnabled(true);
                user.setEnabled(true);
                pass.setEnabled(true);
                conn.close();
                conn = null;
                startB.setEnabled(false);
            }
        } catch (SQLException ex) {
            Logger.getLogger(Visual_Class.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(rootPane, ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
        } catch (InstantiationException ex) {
            Logger.getLogger(Visual_Class.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(rootPane, ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
        } catch (IllegalAccessException ex) {
            Logger.getLogger(Visual_Class.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(rootPane, ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(Visual_Class.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(rootPane, ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_connectBActionPerformed

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        // TODO add your handling code here:
        if (jComboBox1.getSelectedItem().toString().equalsIgnoreCase("postgresql")) {
            driver = DriverType.PostgreSQL;
            port.setValue(new Integer(5432));
        } else {
            driver = DriverType.MysqlDriver;
            port.setValue(new Integer(3606));
        }
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void serverKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_serverKeyReleased
        // TODO add your handling code here:
        validateInterface();
    }//GEN-LAST:event_serverKeyReleased

    private void dbnameKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_dbnameKeyReleased
        // TODO add your handling code here:
        validateInterface();
    }//GEN-LAST:event_dbnameKeyReleased

    private void userKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_userKeyReleased
        // TODO add your handling code here:
        validateInterface();
    }//GEN-LAST:event_userKeyReleased

    private void passKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_passKeyReleased
        // TODO add your handling code here:
        validateInterface();
    }//GEN-LAST:event_passKeyReleased

    private void startBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startBActionPerformed
        if (startB.getText().equalsIgnoreCase("start")) {
            thread = new Thread() {
                @Override
                public void run() {
                    startB.setText("Stop");
                    HiloTime h = new HiloTime(time);
                    h.start();
                    mode.setEnabled(false);
                    urlT.setEnabled(false);
                    nativeStore.setEnabled(false);
                    r2rmlFile.setEnabled(false);
                    outputB.setEnabled(false);
                    output.setEnabled(false);
                    outputNSB1.setEnabled(false);
                    outputR2B2.setEnabled(false);
                    connectB.setEnabled(false);
                    jCheckBox1.setEnabled(false);
                    SesameDataSet g = null;
                    try {
                        RDFFormat rdfFormat = RDFFormat.RDFXML; // Turtle by default
                        // Norm version
                        Version version = Version.WD_20120529;
                        String baseURI = urlT.getText();

                        File outputFile = new File(output.getText());
                        // Extract database model
                        String n = null;
                        if (jCheckBox1.isSelected()) {
                            n = nativeStore.getText();
                        }
                        if (mode.getSelectedItem().toString().equalsIgnoreCase("r2rml")) {
                            g = R2RMLProcessor.convertDatabase(conn, r2rmlFile.getText(), baseURI, n, driver);
                        } else {
                            g = DirectMapper.generateDirectMapping(conn, version, driver,
                                    baseURI, null, n);
                        }
                        // Dump graph
                        log.info("Serialize RDF graph...");
                        g.dumpRDF(outputFile.getAbsolutePath(), rdfFormat);
                        log.info("RDF graph serialized into " + outputFile.getAbsolutePath());
                        h.stop();
                        JOptionPane.showMessageDialog(null, "RDF graph serialized into:\n" + outputFile.getAbsolutePath());
                    } catch (Exception ex) {
                        Logger.getLogger(Visual_Class.class.getName()).log(Level.SEVERE, null, ex);
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
                    } finally {
                        startB.setText("Start");
                        mode.setEnabled(true);
                        urlT.setEnabled(true);
                        outputB.setEnabled(true);
                        output.setEnabled(true);
                        outputNSB1.setEnabled(true);
                        outputR2B2.setEnabled(true);
                        connectB.setEnabled(true);
                        jCheckBox1.setEnabled(true);
                        nativeStore.setEnabled(true);
                        r2rmlFile.setEnabled(true);
                        h.stop();
                    }
                }
            };
            thread.start();
        } else {
            thread.stop();
        }
    }//GEN-LAST:event_startBActionPerformed

    private void outputBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_outputBActionPerformed
        // TODO add your handling code here:
        JFileChooser fc = new JFileChooser();
        if (fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
            output.setText(fc.getSelectedFile().toString());
        }
    }//GEN-LAST:event_outputBActionPerformed

    private void outputNSB1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_outputNSB1ActionPerformed
        // TODO add your handling code here:
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(JFileChooser.DIRECTORIES_ONLY);
        if (fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            nativeStore.setText(fc.getSelectedFile().toString());
        }
    }//GEN-LAST:event_outputNSB1ActionPerformed

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
        // TODO add your handling code here:
        outputNSB1.setEnabled(jCheckBox1.isSelected());
    }//GEN-LAST:event_jCheckBox1ActionPerformed

    private void outputR2B2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_outputR2B2ActionPerformed
        // TODO add your handling code here:
        JFileChooser fc = new JFileChooser();
        if (fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            r2rmlFile.setText(fc.getSelectedFile().toString());
            validateStart();
        }
    }//GEN-LAST:event_outputR2B2ActionPerformed

    private void modeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_modeActionPerformed
        // TODO add your handling code here:
        if (mode.getSelectedItem().toString().equalsIgnoreCase("r2rml")) {
            outputR2B2.setEnabled(true);
        } else {
            outputR2B2.setEnabled(false);
        }
        validateStart();
    }//GEN-LAST:event_modeActionPerformed

    private void dbnameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dbnameActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_dbnameActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(Visual_Class.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(Visual_Class.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(Visual_Class.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Visual_Class.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                Visual_Class.getInterface().setVisible(true);
            }
        });
    }

    public void setCurrentTableName(String tableName) {
        currentTable.setText(tableName);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton connectB;
    private javax.swing.JLabel currentTable;
    private javax.swing.JLabel currentTuple;
    private javax.swing.JTextField dbname;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JLabel labelpass;
    private javax.swing.JComboBox mode;
    private javax.swing.JTextField nativeStore;
    private javax.swing.JTextField output;
    private javax.swing.JButton outputB;
    private javax.swing.JButton outputNSB1;
    private javax.swing.JButton outputR2B2;
    private javax.swing.JPasswordField pass;
    private javax.swing.JSpinner port;
    private javax.swing.JProgressBar progress;
    private javax.swing.JTextField r2rmlFile;
    private javax.swing.JTextField server;
    private javax.swing.JButton startB;
    private javax.swing.JLabel time;
    private javax.swing.JLabel tuplesNumber;
    private javax.swing.JTextField urlT;
    private javax.swing.JTextField user;
    // End of variables declaration//GEN-END:variables

    private void validateInterface() {
        if (server.getText().length() > 0 && dbname.getText().length() > 0 && user.getText().length() > 0) {
            connectB.setEnabled(true);
        } else {
            connectB.setEnabled(false);
        }
    }

    public void setnbTuples(int nbTuples) {
        tuplesNumber.setText(Integer.toString(nbTuples));
        progress.setMinimum(0);
        progress.setMaximum(100);
        cont = 0;
    }

    public void setCurrentTuple(int currentNbTuplesExtractedInTable) {
        currentTuple.setText(Integer.toString(currentNbTuplesExtractedInTable));
    }

    public void setProgress(int ratio) {
        progress.setValue(ratio);
    }

    private void validateStart() {
        if (r2rmlFile.getText().length() > 0 || !mode.getSelectedItem().toString().equalsIgnoreCase("r2rml")) {
            startB.setEnabled(true);
        } else {
            startB.setEnabled(false);
        }
    }
    int cont = 0;

    public void increment() {
        cont++;
        currentTuple.setText(Integer.toString(cont));
        progress.setValue(cont * 100 / Integer.parseInt(tuplesNumber.getText()));
    }
}
